//
//  table__p_o_s_t.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTable.h>

typedef enum : Fixed {
	OTPostTableFormatType1 = 0x00010000,
	OTPostTableFormatType2 = 0x00020000,
	OTPostTableFormatType2_5 = 0x00025000,
	OTPostTableFormatType3 = 0x00030000,
} OTPostTableFormatType;

@interface table__p_o_s_t : TTable {
	OTPostTableFormatType _formatType;
	CGFloat _italicAngle;		   // 16.16F	 // italic angle in degrees
	NSInteger _underlinePosition;  // h
	NSInteger _underlineThickness; // h
	BOOL _isFixedPitch;			   // L
	uint32_t _minMemType42;		   // L	// minimum memory if TrueType font is downloaded
	uint32_t _maxMemType42;		   // L	// maximum memory if TrueType font is downloaded
	uint32_t _minMemType1;		   // L	// minimum memory if Type1 font is downloaded
	uint32_t _maxMemType1;		   // L	// maximum memory if Type1 font is downloaded
	NSArray *_extraNames;
	NSMutableDictionary *_mapping;
}
@property (nonatomic, assign) OTPostTableFormatType formatType;
@property (nonatomic, assign) CGFloat italicAngle;
@property (nonatomic, assign) NSInteger underlinePosition;
@property (nonatomic, assign) NSInteger underlineThickness;
@property (nonatomic, assign) BOOL isFixedPitch;
@property (nonatomic, assign) uint32_t minMemType42;
@property (nonatomic, assign) uint32_t maxMemType42;
@property (nonatomic, assign) uint32_t minMemType1;
@property (nonatomic, assign) uint32_t maxMemType1;
@property (nonatomic, strong) NSArray *extraNames;
@property (nonatomic, strong) NSMutableDictionary *mapping;
@end
